<?php
/**
 * Class that operate on table 'onlinetempstorereport'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-13 10:55
 */
class OnlinetempstorereportMySqlDAO implements OnlinetempstorereportDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OnlinetempstorereportMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE storereportid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM onlinetempstorereport';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM onlinetempstorereport ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param onlinetempstorereport primary key
 	 */
	public function delete($storereportid){
		$sql = 'DELETE FROM onlinetempstorereport WHERE storereportid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($storereportid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OnlinetempstorereportMySql onlinetempstorereport
 	 */
	public function insert($onlinetempstorereport){
		$sql = 'INSERT INTO onlinetempstorereport (productid, storeid, productquantity, storereporttype, storereportmodelid, processname, tablename, productbefore, productafter, userid, storereportdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempstorereport->productid);
		$sqlQuery->setNumber($onlinetempstorereport->storeid);
		$sqlQuery->set($onlinetempstorereport->productquantity);
		$sqlQuery->setNumber($onlinetempstorereport->storereporttype);
		$sqlQuery->setNumber($onlinetempstorereport->storereportmodelid);
		$sqlQuery->set($onlinetempstorereport->processname);
		$sqlQuery->set($onlinetempstorereport->tablename);
		$sqlQuery->set($onlinetempstorereport->productbefore);
		$sqlQuery->set($onlinetempstorereport->productafter);
		$sqlQuery->setNumber($onlinetempstorereport->userid);
		$sqlQuery->set($onlinetempstorereport->storereportdate);

		$id = $this->executeInsert($sqlQuery);	
		$onlinetempstorereport->storereportid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OnlinetempstorereportMySql onlinetempstorereport
 	 */
	public function update($onlinetempstorereport){
		$sql = 'UPDATE onlinetempstorereport SET productid = ?, storeid = ?, productquantity = ?, storereporttype = ?, storereportmodelid = ?, processname = ?, tablename = ?, productbefore = ?, productafter = ?, userid = ?, storereportdate = ? WHERE storereportid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempstorereport->productid);
		$sqlQuery->setNumber($onlinetempstorereport->storeid);
		$sqlQuery->set($onlinetempstorereport->productquantity);
		$sqlQuery->setNumber($onlinetempstorereport->storereporttype);
		$sqlQuery->setNumber($onlinetempstorereport->storereportmodelid);
		$sqlQuery->set($onlinetempstorereport->processname);
		$sqlQuery->set($onlinetempstorereport->tablename);
		$sqlQuery->set($onlinetempstorereport->productbefore);
		$sqlQuery->set($onlinetempstorereport->productafter);
		$sqlQuery->setNumber($onlinetempstorereport->userid);
		$sqlQuery->set($onlinetempstorereport->storereportdate);

		$sqlQuery->setNumber($onlinetempstorereport->storereportid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM onlinetempstorereport';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStoreid($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE storeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductquantity($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE productquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStorereporttype($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE storereporttype = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStorereportmodelid($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE storereportmodelid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProcessname($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE processname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTablename($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductbefore($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE productbefore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductafter($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE productafter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStorereportdate($value){
		$sql = 'SELECT * FROM onlinetempstorereport WHERE storereportdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProductid($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStoreid($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE storeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductquantity($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE productquantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStorereporttype($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE storereporttype = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStorereportmodelid($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE storereportmodelid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProcessname($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE processname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTablename($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE tablename = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductbefore($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE productbefore = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductafter($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE productafter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStorereportdate($value){
		$sql = 'DELETE FROM onlinetempstorereport WHERE storereportdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OnlinetempstorereportMySql 
	 */
	protected function readRow($row){
		$onlinetempstorereport = new Onlinetempstorereport();
		
		$onlinetempstorereport->storereportid = $row['storereportid'];
		$onlinetempstorereport->productid = $row['productid'];
		$onlinetempstorereport->storeid = $row['storeid'];
		$onlinetempstorereport->productquantity = $row['productquantity'];
		$onlinetempstorereport->storereporttype = $row['storereporttype'];
		$onlinetempstorereport->storereportmodelid = $row['storereportmodelid'];
		$onlinetempstorereport->processname = $row['processname'];
		$onlinetempstorereport->tablename = $row['tablename'];
		$onlinetempstorereport->productbefore = $row['productbefore'];
		$onlinetempstorereport->productafter = $row['productafter'];
		$onlinetempstorereport->userid = $row['userid'];
		$onlinetempstorereport->storereportdate = $row['storereportdate'];

		return $onlinetempstorereport;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OnlinetempstorereportMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>